/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.AllocationInstruction;
import com.sun.org.apache.bcel.internal.generic.ArrayInstruction;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BranchHandle;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.CHECKCAST;
import com.sun.org.apache.bcel.internal.generic.CPInstruction;
import com.sun.org.apache.bcel.internal.generic.CodeExceptionGen;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ConstantPushInstruction;
import com.sun.org.apache.bcel.internal.generic.EmptyVisitor;
import com.sun.org.apache.bcel.internal.generic.FieldInstruction;
import com.sun.org.apache.bcel.internal.generic.IINC;
import com.sun.org.apache.bcel.internal.generic.INSTANCEOF;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionConst;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InvokeInstruction;
import com.sun.org.apache.bcel.internal.generic.LDC;
import com.sun.org.apache.bcel.internal.generic.LDC2_W;
import com.sun.org.apache.bcel.internal.generic.LocalVariableInstruction;
import com.sun.org.apache.bcel.internal.generic.MULTIANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.NEWARRAY;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.RET;
import com.sun.org.apache.bcel.internal.generic.ReturnInstruction;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.BCELifier;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class BCELFactory
extends EmptyVisitor {
    private static final String CONSTANT_PREFIX = Const.class.getSimpleName() + ".";
    private final MethodGen _mg;
    private final PrintWriter _out;
    private final ConstantPoolGen _cp;
    private final Map<Instruction, InstructionHandle> branch_map = new HashMap<Instruction, InstructionHandle>();
    private final List<BranchInstruction> branches = new ArrayList<BranchInstruction>();

    BCELFactory(MethodGen methodGen, PrintWriter printWriter) {
        this._mg = methodGen;
        this._cp = methodGen.getConstantPool();
        this._out = printWriter;
    }

    public void start() {
        if (!this._mg.isAbstract() && !this._mg.isNative()) {
            for (InstructionHandle instructionHandle = this._mg.getInstructionList().getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
                Instruction instruction = instructionHandle.getInstruction();
                if (instruction instanceof BranchInstruction) {
                    this.branch_map.put(instruction, instructionHandle);
                }
                if (instructionHandle.hasTargeters()) {
                    if (instruction instanceof BranchInstruction) {
                        this._out.println("    InstructionHandle ih_" + instructionHandle.getPosition() + ";");
                    } else {
                        this._out.print("    InstructionHandle ih_" + instructionHandle.getPosition() + " = ");
                    }
                } else {
                    this._out.print("    ");
                }
                if (this.visitInstruction(instruction)) continue;
                instruction.accept(this);
            }
            this.updateBranchTargets();
            this.updateExceptionHandlers();
        }
    }

    private boolean visitInstruction(Instruction instruction) {
        short s = instruction.getOpcode();
        if (InstructionConst.getInstruction(s) != null && !(instruction instanceof ConstantPushInstruction) && !(instruction instanceof ReturnInstruction)) {
            this._out.println("il.append(InstructionConst." + instruction.getName().toUpperCase(Locale.ENGLISH) + ");");
            return true;
        }
        return false;
    }

    @Override
    public void visitLocalVariableInstruction(LocalVariableInstruction localVariableInstruction) {
        short s = localVariableInstruction.getOpcode();
        Type type = localVariableInstruction.getType(this._cp);
        if (s == 132) {
            this._out.println("il.append(new IINC(" + localVariableInstruction.getIndex() + ", " + ((IINC)localVariableInstruction).getIncrement() + "));");
        } else {
            String string = s < 54 ? "Load" : "Store";
            this._out.println("il.append(_factory.create" + string + "(" + BCELifier.printType(type) + ", " + localVariableInstruction.getIndex() + "));");
        }
    }

    @Override
    public void visitArrayInstruction(ArrayInstruction arrayInstruction) {
        short s = arrayInstruction.getOpcode();
        Type type = arrayInstruction.getType(this._cp);
        String string = s < 79 ? "Load" : "Store";
        this._out.println("il.append(_factory.createArray" + string + "(" + BCELifier.printType(type) + "));");
    }

    @Override
    public void visitFieldInstruction(FieldInstruction fieldInstruction) {
        short s = fieldInstruction.getOpcode();
        String string = fieldInstruction.getReferenceType(this._cp).getSignature();
        String string2 = fieldInstruction.getFieldName(this._cp);
        Type type = fieldInstruction.getFieldType(this._cp);
        this._out.println("il.append(_factory.createFieldAccess(\"" + string + "\", \"" + string2 + "\", " + BCELifier.printType(type) + ", " + CONSTANT_PREFIX + Const.getOpcodeName(s).toUpperCase(Locale.ENGLISH) + "));");
    }

    @Override
    public void visitInvokeInstruction(InvokeInstruction invokeInstruction) {
        short s = invokeInstruction.getOpcode();
        String string = invokeInstruction.getReferenceType(this._cp).getSignature();
        String string2 = invokeInstruction.getMethodName(this._cp);
        Type type = invokeInstruction.getReturnType(this._cp);
        Type[] typeArray = invokeInstruction.getArgumentTypes(this._cp);
        this._out.println("il.append(_factory.createInvoke(\"" + string + "\", \"" + string2 + "\", " + BCELifier.printType(type) + ", " + BCELifier.printArgumentTypes(typeArray) + ", " + CONSTANT_PREFIX + Const.getOpcodeName(s).toUpperCase(Locale.ENGLISH) + "));");
    }

    @Override
    public void visitAllocationInstruction(AllocationInstruction allocationInstruction) {
        Type type = allocationInstruction instanceof CPInstruction ? ((CPInstruction)((Object)allocationInstruction)).getType(this._cp) : ((NEWARRAY)allocationInstruction).getType();
        short s = ((Instruction)((Object)allocationInstruction)).getOpcode();
        short s2 = 1;
        switch (s) {
            case 187: {
                this._out.println("il.append(_factory.createNew(\"" + ((ObjectType)type).getClassName() + "\"));");
                break;
            }
            case 197: {
                s2 = ((MULTIANEWARRAY)allocationInstruction).getDimensions();
            }
            case 188: 
            case 189: {
                if (type instanceof ArrayType) {
                    type = ((ArrayType)type).getBasicType();
                }
                this._out.println("il.append(_factory.createNewArray(" + BCELifier.printType(type) + ", (short) " + s2 + "));");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled opcode: " + s);
            }
        }
    }

    private void createConstant(Object object) {
        String string = object.toString();
        if (object instanceof String) {
            string = '\"' + Utility.convertString(string) + '\"';
        } else if (object instanceof Character) {
            string = "(char)0x" + Integer.toHexString(((Character)object).charValue());
        } else if (object instanceof Float) {
            string = string + "f";
        } else if (object instanceof Long) {
            string = string + "L";
        } else if (object instanceof ObjectType) {
            ObjectType objectType = (ObjectType)object;
            string = "new ObjectType(\"" + objectType.getClassName() + "\")";
        }
        this._out.println("il.append(new PUSH(_cp, " + string + "));");
    }

    @Override
    public void visitLDC(LDC lDC) {
        this.createConstant(lDC.getValue(this._cp));
    }

    @Override
    public void visitLDC2_W(LDC2_W lDC2_W) {
        this.createConstant(lDC2_W.getValue(this._cp));
    }

    @Override
    public void visitConstantPushInstruction(ConstantPushInstruction constantPushInstruction) {
        this.createConstant(constantPushInstruction.getValue());
    }

    @Override
    public void visitINSTANCEOF(INSTANCEOF iNSTANCEOF) {
        Type type = iNSTANCEOF.getType(this._cp);
        this._out.println("il.append(new INSTANCEOF(_cp.addClass(" + BCELifier.printType(type) + ")));");
    }

    @Override
    public void visitCHECKCAST(CHECKCAST cHECKCAST) {
        Type type = cHECKCAST.getType(this._cp);
        this._out.println("il.append(_factory.createCheckCast(" + BCELifier.printType(type) + "));");
    }

    @Override
    public void visitReturnInstruction(ReturnInstruction returnInstruction) {
        Type type = returnInstruction.getType(this._cp);
        this._out.println("il.append(_factory.createReturn(" + BCELifier.printType(type) + "));");
    }

    @Override
    public void visitBranchInstruction(BranchInstruction branchInstruction) {
        BranchHandle branchHandle = (BranchHandle)this.branch_map.get(branchInstruction);
        int n = branchHandle.getPosition();
        String string = branchInstruction.getName() + "_" + n;
        if (branchInstruction instanceof Select) {
            int n2;
            Select select = (Select)branchInstruction;
            this.branches.add(branchInstruction);
            StringBuilder stringBuilder = new StringBuilder("new int[] { ");
            int[] nArray = select.getMatchs();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                stringBuilder.append(nArray[n2]);
                if (n2 >= nArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(" }");
            this._out.print("Select " + string + " = new " + branchInstruction.getName().toUpperCase(Locale.ENGLISH) + "(" + stringBuilder + ", new InstructionHandle[] { ");
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this._out.print("null");
                if (n2 >= nArray.length - 1) continue;
                this._out.print(", ");
            }
            this._out.println(" }, null);");
        } else {
            String string2;
            int n3 = branchHandle.getTarget().getPosition();
            if (n > n3) {
                string2 = "ih_" + n3;
            } else {
                this.branches.add(branchInstruction);
                string2 = "null";
            }
            this._out.println("    BranchInstruction " + string + " = _factory.createBranchInstruction(" + CONSTANT_PREFIX + branchInstruction.getName().toUpperCase(Locale.ENGLISH) + ", " + string2 + ");");
        }
        if (branchHandle.hasTargeters()) {
            this._out.println("    ih_" + n + " = il.append(" + string + ");");
        } else {
            this._out.println("    il.append(" + string + ");");
        }
    }

    @Override
    public void visitRET(RET rET) {
        this._out.println("il.append(new RET(" + rET.getIndex() + ")));");
    }

    private void updateBranchTargets() {
        for (BranchInstruction branchInstruction : this.branches) {
            BranchHandle branchHandle = (BranchHandle)this.branch_map.get(branchInstruction);
            int n = branchHandle.getPosition();
            String string = branchInstruction.getName() + "_" + n;
            int n2 = branchHandle.getTarget().getPosition();
            this._out.println("    " + string + ".setTarget(ih_" + n2 + ");");
            if (!(branchInstruction instanceof Select)) continue;
            InstructionHandle[] instructionHandleArray = ((Select)branchInstruction).getTargets();
            for (int i = 0; i < instructionHandleArray.length; ++i) {
                n2 = instructionHandleArray[i].getPosition();
                this._out.println("    " + string + ".setTarget(" + i + ", ih_" + n2 + ");");
            }
        }
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] codeExceptionGenArray;
        for (CodeExceptionGen codeExceptionGen : codeExceptionGenArray = this._mg.getExceptionHandlers()) {
            String string = codeExceptionGen.getCatchType() == null ? "null" : BCELifier.printType(codeExceptionGen.getCatchType());
            this._out.println("    method.addExceptionHandler(ih_" + codeExceptionGen.getStartPC().getPosition() + ", ih_" + codeExceptionGen.getEndPC().getPosition() + ", ih_" + codeExceptionGen.getHandlerPC().getPosition() + ", " + string + ");");
        }
    }
}

