/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMapType
implements Cloneable {
    private byte type;
    private int index = -1;
    private ConstantPool constantPool;

    StackMapType(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(dataInput.readByte(), -1, constantPool);
        if (this.hasIndex()) {
            this.index = dataInput.readShort();
        }
        this.constantPool = constantPool;
    }

    public StackMapType(byte by, int n, ConstantPool constantPool) {
        if (by < 0 || by > 8) {
            throw new IllegalArgumentException("Illegal type for StackMapType: " + by);
        }
        this.type = by;
        this.index = n;
        this.constantPool = constantPool;
    }

    public void setType(byte by) {
        if (by < 0 || by > 8) {
            throw new IllegalArgumentException("Illegal type for StackMapType: " + by);
        }
        this.type = by;
    }

    public byte getType() {
        return this.type;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        if (this.hasIndex()) {
            dataOutputStream.writeShort(this.getIndex());
        }
    }

    public boolean hasIndex() {
        return this.type == 7 || this.type == 8;
    }

    private String printIndex() {
        if (this.type == 7) {
            if (this.index < 0) {
                return ", class=<unknown>";
            }
            return ", class=" + this.constantPool.constantToString(this.index, (byte)7);
        }
        if (this.type == 8) {
            return ", offset=" + this.index;
        }
        return "";
    }

    public String toString() {
        return "(type=" + Const.getItemName(this.type) + this.printIndex() + ")";
    }

    public StackMapType copy() {
        try {
            return (StackMapType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }
}

