/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class PMGClass
extends Attribute {
    private int pmgClassIndex;
    private int pmgIndex;

    public PMGClass(PMGClass pMGClass) {
        this(pMGClass.getNameIndex(), pMGClass.getLength(), pMGClass.getPMGIndex(), pMGClass.getPMGClassIndex(), pMGClass.getConstantPool());
    }

    PMGClass(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), constantPool);
    }

    public PMGClass(int n, int n2, int n3, int n4, ConstantPool constantPool) {
        super((byte)9, n, n2, constantPool);
        this.pmgIndex = n3;
        this.pmgClassIndex = n4;
    }

    @Override
    public void accept(Visitor visitor) {
        PMGClass.println("Visiting non-standard PMGClass object");
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.pmgIndex);
        dataOutputStream.writeShort(this.pmgClassIndex);
    }

    public int getPMGClassIndex() {
        return this.pmgClassIndex;
    }

    public void setPMGClassIndex(int n) {
        this.pmgClassIndex = n;
    }

    public int getPMGIndex() {
        return this.pmgIndex;
    }

    public void setPMGIndex(int n) {
        this.pmgIndex = n;
    }

    public String getPMGName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)super.getConstantPool().getConstant(this.pmgIndex, (byte)1);
        return constantUtf8.getBytes();
    }

    public String getPMGClassName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)super.getConstantPool().getConstant(this.pmgClassIndex, (byte)1);
        return constantUtf8.getBytes();
    }

    @Override
    public String toString() {
        return "PMGClass(" + this.getPMGName() + ", " + this.getPMGClassName() + ")";
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        return (Attribute)this.clone();
    }
}

