/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import jdk.xml.internal.SecuritySupport;

public final class LineNumberTable
extends Attribute {
    private static final int MAX_LINE_LENGTH = 72;
    private LineNumber[] lineNumberTable;

    public LineNumberTable(LineNumberTable lineNumberTable) {
        this(lineNumberTable.getNameIndex(), lineNumberTable.getLength(), lineNumberTable.getLineNumberTable(), lineNumberTable.getConstantPool());
    }

    public LineNumberTable(int n, int n2, LineNumber[] lineNumberArray, ConstantPool constantPool) {
        super((byte)4, n, n2, constantPool);
        this.lineNumberTable = lineNumberArray;
    }

    LineNumberTable(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (LineNumber[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.lineNumberTable = new LineNumber[n3];
        for (int i = 0; i < n3; ++i) {
            this.lineNumberTable[i] = new LineNumber(dataInput);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLineNumberTable(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.lineNumberTable.length);
        for (LineNumber lineNumber : this.lineNumberTable) {
            lineNumber.dump(dataOutputStream);
        }
    }

    public LineNumber[] getLineNumberTable() {
        return this.lineNumberTable;
    }

    public void setLineNumberTable(LineNumber[] lineNumberArray) {
        this.lineNumberTable = lineNumberArray;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < this.lineNumberTable.length; ++i) {
            stringBuilder2.append(this.lineNumberTable[i].toString());
            if (i < this.lineNumberTable.length - 1) {
                stringBuilder2.append(", ");
            }
            if (stringBuilder2.length() <= 72 || i >= this.lineNumberTable.length - 1) continue;
            stringBuilder2.append(SecuritySupport.NEWLINE);
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder2.setLength(0);
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        return stringBuilder.toString();
    }

    public int getSourceLine(int n) {
        int n2 = 0;
        int n3 = this.lineNumberTable.length - 1;
        if (n3 < 0) {
            return -1;
        }
        int n4 = -1;
        int n5 = -1;
        do {
            int n6;
            int n7;
            if ((n7 = this.lineNumberTable[n6 = n2 + n3 >>> 1].getStartPC()) == n) {
                return this.lineNumberTable[n6].getLineNumber();
            }
            if (n < n7) {
                n3 = n6 - 1;
            } else {
                n2 = n6 + 1;
            }
            if (n7 >= n || n7 <= n5) continue;
            n5 = n7;
            n4 = n6;
        } while (n2 <= n3);
        if (n4 < 0) {
            return -1;
        }
        return this.lineNumberTable[n4].getLineNumber();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        LineNumberTable lineNumberTable = (LineNumberTable)this.clone();
        lineNumberTable.lineNumberTable = new LineNumber[this.lineNumberTable.length];
        for (int i = 0; i < this.lineNumberTable.length; ++i) {
            lineNumberTable.lineNumberTable[i] = this.lineNumberTable[i].copy();
        }
        lineNumberTable.setConstantPool(constantPool);
        return lineNumberTable;
    }

    public int getTableLength() {
        return this.lineNumberTable == null ? 0 : this.lineNumberTable.length;
    }
}

